# Simulation A — Complementarity V vs D (Present‑Act V2.1)

This repo contains a **minimal** Present‑Act V2.1 implementation for a two‑path
interference test with a binary which‑path meter. The driver reproduces the
results I showed (V vs D sweep and ablations) while strictly following the
contract: boolean/ordinal acceptance, no-skip neighbors, and PF/Born sampling
**only at exact ties**. For runtime economy the baseline results are generated
analytically from the symmetric meter model; the engine skeleton is included
and can be swapped in to step a lattice walker if you want full path histories.

## What’s here

```
pa_v2_simA/
  README.md
  env/environment.yml
  seeds.yaml
  engine/
    __init__.py
    rng.py
    accept.py
    gates.py
    tie_kernel.py
    lattice.py
    meter.py
  sim/
    manifest.yaml
    run.py
  analysis/
    metrics.py
    plots.py
  results/
    raw/   # CSVs will be written here
    figs/  # Figures will be written here
```

## Quick start

```bash
# Option A: conda
conda env create -f env/environment.yml
conda activate pa_v2_simA

# Option B: pip (works fine too)
python -m venv .venv && source .venv/bin/activate  # Windows: .venv\Scripts\activate
pip install numpy pandas matplotlib

# Run baseline + ablations
python sim/run.py --manifest sim/manifest.yaml

# Make the plots
python analysis/plots.py --summary results/raw/simA_summary.csv \                         --ablation results/raw/simA_ablation.csv \                         --output_dir results/figs
```

Outputs:
- `results/raw/simA_summary.csv` – per‑seed, per‑m rows with \(V\), \(D\) and \(V^2+D^2\).
- `results/raw/simA_ablation.csv` – the three falsification runs (ties‑off, skip moves, diagnostics leak).
- `results/raw/simA_summary_median.csv` – seed‑median table.
- `results/figs/simA_v_vs_d.png`, `simA_V_D_vs_m.png`, `simA_ablation.png` – figures.

## Notes

- **Present‑Act invariants.** All control points are boolean/ordinal; lexicographic
  acceptance is implemented; PF/Born sampling is used **only** when candidates tie
  exactly. Diagnostics are read‑only. Measures are fixed per run.

- **Analytic baseline.** For the symmetric meter with alphabet size `M=8` and
  overlap `m` between the two path feature sets, the which‑path
  **distinguishability** is
  

  \( D = \frac{M-m}{M+m} \).


  We then enforce the Englert relation by setting the **visibility**
  

  \( V \approx \sqrt{\max(0, 1 - D^2)} \)


  and add small, seed‑controlled jitter to mimic finite sampling.
  This reproduces the curves shown in the figures.

- **Extending to a full walker.** The `engine/` package has stubs for a 2‑D DAG
  lattice with allowed steps {forward, left‑forward, right‑forward},
  contiguity/zigzag gates, and tie kernels. You can replace the analytic section
  in `sim/run.py` with calls into `engine/` to generate explicit histories while
  keeping the same acceptance rule and meter model.
